/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.FontSizeHints;
import com.jgoodies.looks.FontUtils;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.windows.WindowsBorders;
import com.jgoodies.looks.windows.WindowsIconFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;

public final class WindowsLookAndFeel
extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel {
    public static final String BORDER_STYLE_KEY = "jgoodies.windows.borderStyle";
    private static FontSizeHints fontSizeHints = null;

    public String getID() {
        return "JGoodies Windows";
    }

    public String getName() {
        return "JGoodies Windows";
    }

    public String getDescription() {
        return "The JGoodies Windows Look and Feel - \u00a9 2001-2005 JGoodies Karsten Lentzsch";
    }

    public static FontSizeHints getFontSizeHints() {
        return fontSizeHints != null ? fontSizeHints : Options.getGlobalFontSizeHints();
    }

    public static void setFontSizeHints(FontSizeHints newHints) {
        fontSizeHints = newHints;
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String WINDOWS_PREFIX = "com.jgoodies.looks.windows.Windows";
        String COMMON_PREFIX = "com.jgoodies.looks.common.ExtBasic";
        String menuUIPrefix = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? WINDOWS_PREFIX : COMMON_PREFIX;
        Object[] uiDefaults = new Object[]{"ButtonUI", WINDOWS_PREFIX + "ButtonUI", "ToggleButtonUI", WINDOWS_PREFIX + "ToggleButtonUI", "ComboBoxUI", WINDOWS_PREFIX + "ComboBoxUI", "ScrollPaneUI", WINDOWS_PREFIX + "ScrollPaneUI", "MenuBarUI", WINDOWS_PREFIX + "MenuBarUI", "MenuUI", menuUIPrefix + "MenuUI", "MenuItemUI", COMMON_PREFIX + "MenuItemUI", "CheckBoxMenuItemUI", COMMON_PREFIX + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", COMMON_PREFIX + "RadioButtonMenuItemUI", "PopupMenuSeparatorUI", COMMON_PREFIX + "PopupMenuSeparatorUI", "OptionPaneUI", WINDOWS_PREFIX + "OptionPaneUI", "SplitPaneUI", WINDOWS_PREFIX + "SplitPaneUI", "TabbedPaneUI", WINDOWS_PREFIX + "TabbedPaneUI", "TreeUI", WINDOWS_PREFIX + "TreeUI", "SeparatorUI", WINDOWS_PREFIX + "SeparatorUI"};
        if (LookUtils.IS_JAVA_1_4_2_OR_LATER) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "SpinnerUI", WINDOWS_PREFIX + "SpinnerUI");
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "PasswordFieldUI", WINDOWS_PREFIX + "XPPasswordFieldUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", WINDOWS_PREFIX + "XPToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "TableHeaderUI", WINDOWS_PREFIX + "XPTableHeaderUI");
        } else {
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarUI", WINDOWS_PREFIX + "ToolBarUI");
            uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ScrollBarUI", WINDOWS_PREFIX + "ScrollBarUI");
            if (!LookUtils.IS_JAVA_1_4_2_OR_LATER) {
                uiDefaults = WindowsLookAndFeel.append(uiDefaults, "ToolBarSeparatorUI", WINDOWS_PREFIX + "ToolBarSeparatorUI");
            }
        }
        table.putDefaults(uiDefaults);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        boolean isXP = LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
        if (FontUtils.useSystemFontSettings()) {
            this.initFontDefaults(table);
        }
        if (!isXP) {
            this.initComponentDefaultsNoXP(table);
        }
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        InsetsUIResource checkBoxMargin = new InsetsUIResource(2, 0, 2, 0);
        UIDefaults.ProxyLazyValue etchedBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        SimpleProxyLazyValue buttonBorder = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getButtonBorder");
        Border menuBorder = WindowsBorders.getMenuBorder();
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border menuBarHeaderBorder = WindowsBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = WindowsBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = WindowsBorders.getEtchedBorder();
        Border toolBarHeaderBorder = WindowsBorders.getToolBarHeaderBorder();
        Insets defaultButtonMargin = LookUtils.createButtonMargin(false);
        Insets narrowButtonMargin = LookUtils.createButtonMargin(true);
        DimensionUIResource toolBarSeparatorSize = LookUtils.IS_JAVA_1_4_2_OR_LATER ? null : new DimensionUIResource(6, Options.getDefaultIconSize().height);
        InsetsUIResource textInsets = new InsetsUIResource(2, 2, 2, 2);
        InsetsUIResource comboRendererMargin = LookUtils.IS_JAVA_1_4 ? textInsets : new InsetsUIResource(0, 0, 0, 0);
        InsetsUIResource menuItemMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(3, 0, 3, 0) : new InsetsUIResource(2, 0, 2, 0);
        InsetsUIResource menuMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(2, 3, 2, 3) : new InsetsUIResource(2, 4, 2, 4);
        int pad = isXP ? 3 : 0;
        InsetsUIResource popupMenuSeparatorMargin = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(2, pad, 3, pad) : new InsetsUIResource(3, pad, 4, pad);
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Class<?> superclass = ((Object)((Object)this)).getClass().getSuperclass();
        Color controlColor = table.getColor("control");
        Object menuBarBackground = isXP ? table.get("control") : table.get("menu");
        Object menuSelectionBackground = isXP ? table.get("MenuItem.selectionBackground") : table.get("Menu.background");
        Object menuSelectionForeground = isXP ? table.get("MenuItem.selectionForeground") : table.get("Menu.foreground");
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.margin", defaultButtonMargin, "Button.narrowMargin", narrowButtonMargin, "CheckBox.border", marginBorder, "CheckBox.margin", checkBoxMargin, "ComboBox.editorBorder", marginBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.rendererMargin", comboRendererMargin, "EditorPane.margin", textInsets, "InternalFrame.icon", WindowsLookAndFeel.makeIcon(superclass, (String)"icons/JavaCup.gif"), "Menu.border", menuBorder, "Menu.borderPainted", Boolean.TRUE, "Menu.background", menuBarBackground, "Menu.selectionForeground", menuSelectionForeground, "Menu.selectionBackground", menuSelectionBackground, "Menu.margin", menuMargin, "MenuBar.background", menuBarBackground, "MenuBar.border", menuBarSeparatorBorder, "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "CheckBoxMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.margin", menuItemMargin, "OptionPane.errorIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Error.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Error.gif"), "OptionPane.informationIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Inform.gif"), "OptionPane.warningIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Warn.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Warn.gif"), "OptionPane.questionIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(superclass, (String)"icons/Question.gif"), "FormattedTextField.margin", textInsets, "PasswordField.margin", textInsets, "PopupMenu.border", WindowsBorders.getPopupMenuBorder(), "PopupMenuSeparator.margin", popupMenuSeparatorMargin, "ScrollPane.etchedBorder", etchedBorder, "RadioButton.border", marginBorder, "RadioButton.margin", checkBoxMargin, "Table.gridColor", controlColor, "TextArea.margin", textInsets, "TextField.margin", textInsets, "ToggleButton.margin", defaultButtonMargin, "ToggleButton.narrowMargin", narrowButtonMargin, "ToolBar.border", toolBarEmptyBorder, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolBar.separatorSize", toolBarSeparatorSize, "ToolBar.margin", new InsetsUIResource(0, 10, 0, 0), "Tree.selectionBorderColor", controlColor, "Tree.rowHeight", rowHeight, "Tree.openIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeOpen.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeOpen.gif"), "Tree.closedIcon", isXP ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeClosed.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeClosed.gif")};
        table.putDefaults(defaults);
    }

    private void initComponentDefaultsNoXP(UIDefaults table) {
        SimpleProxyLazyValue checkBoxIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getCheckBoxIcon");
        SimpleProxyLazyValue radioButtonIcon = new SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getRadioButtonIcon");
        BasicBorders.FieldBorder winInsetBorder = new BasicBorders.FieldBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight"));
        Object[] defaults = new Object[]{"CheckBox.checkColor", table.get("controlText"), "CheckBox.icon", checkBoxIcon, "RadioButton.checkColor", table.get("controlText"), "RadioButton.icon", radioButtonIcon, "Table.scrollPaneBorder", winInsetBorder};
        table.putDefaults(defaults);
    }

    private void initFontDefaults(UIDefaults table) {
        Font menuFont = FontUtils.getMenuFont(table, WindowsLookAndFeel.getFontSizeHints());
        Font controlFont = FontUtils.getControlFont(table, WindowsLookAndFeel.getFontSizeHints());
        FontUIResource controlBoldFont = new FontUIResource(controlFont.deriveFont(1));
        Font messageFont = table.getFont("OptionPane.font");
        Font toolTipFont = table.getFont("ToolTip.font");
        Font windowFont = table.getFont("InternalFrame.titleFont");
        FontUtils.initFontDefaults(table, controlFont, controlBoldFont, controlFont, menuFont, messageFont, toolTipFont, windowFont);
    }

    public static Border getButtonBorder() {
        return WindowsBorders.getButtonBorder();
    }

    public static Icon getCheckBoxIcon() {
        return WindowsIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonIcon() {
        return WindowsIconFactory.getRadioButtonIcon();
    }

    private static Object[] append(Object[] source, String key, Object value) {
        int length = source.length;
        Object[] destination = new Object[length + 2];
        System.arraycopy(source, 0, destination, 0, length);
        destination[length] = key;
        destination[length + 1] = value;
        return destination;
    }

    private static class SimpleProxyLazyValue
    implements UIDefaults.LazyValue {
        private final String className;
        private final String methodName;

        public SimpleProxyLazyValue(String c, String m) {
            this.className = c;
            this.methodName = m;
        }

        public Object createValue(UIDefaults table) {
            Object instance = null;
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = table != null ? (ClassLoader)table.get("ClassLoader") : Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> c = Class.forName(this.className, true, classLoader);
                Method m = c.getMethod(this.methodName, null);
                instance = m.invoke(c, null);
            }
            catch (Throwable t) {
                LookUtils.log("Problem creating " + this.className + " with method " + this.methodName + t);
            }
            return instance;
        }
    }
}

