/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.util.CayenneMapEntry;

public class EJBQLJoinAppender {
    protected EJBQLTranslationContext context;
    private Map<String, String> reusableJoins;

    static String makeJoinTailMarker(String id) {
        return "FROM_TAIL" + id;
    }

    public EJBQLJoinAppender(EJBQLTranslationContext context) {
        this.context = context;
    }

    public String registerReusableJoin(String sourceIdPath, String relationship, String targetId) {
        String key;
        String oldId;
        if (this.reusableJoins == null) {
            this.reusableJoins = new HashMap<String, String>();
        }
        if ((oldId = this.reusableJoins.put(key = sourceIdPath + ":" + relationship, targetId)) != null) {
            this.reusableJoins.put(key, oldId);
            return oldId;
        }
        return null;
    }

    public void appendInnerJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "INNER JOIN");
    }

    public void appendOuterJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "LEFT OUTER JOIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId, String semantics) {
        List<DbRelationship> joinRelationships = this.context.getIncomingRelationships(rhsId);
        if (joinRelationships.isEmpty()) {
            throw new EJBQLException("No join configured for id " + rhsId);
        }
        DbRelationship incomingDB = joinRelationships.get(0);
        Entity sourceEntity = incomingDB.getSourceEntity();
        String tableName = sourceEntity instanceof DbEntity ? ((DbEntity)sourceEntity).getFullyQualifiedName() : sourceEntity.getName();
        String sourceAlias = this.context.getTableAlias(lhsId.getEntityId(), tableName);
        if (marker != null) {
            this.context.pushMarker(marker, false);
        }
        try {
            this.context.append(" ").append(semantics);
            String targetAlias = "";
            if (joinRelationships.size() > 1) {
                this.context.append(" ");
                for (int i = 1; i < joinRelationships.size(); ++i) {
                    DbRelationship dbRelationship = joinRelationships.get(i);
                    String subquerySourceTableName = ((DbEntity)dbRelationship.getSourceEntity()).getFullyQualifiedName();
                    String subquerySourceAlias = this.context.getTableAlias(subquerySourceTableName, subquerySourceTableName);
                    String subqueryTargetTableName = ((DbEntity)dbRelationship.getTargetEntity()).getFullyQualifiedName();
                    String subqueryTargetAlias = "";
                    subqueryTargetAlias = i == joinRelationships.size() - 1 ? this.context.getTableAlias(rhsId.getEntityId(), subqueryTargetTableName) : this.context.getTableAlias(subqueryTargetTableName, subqueryTargetTableName);
                    if (i == 1) {
                        this.context.append(subquerySourceTableName).append(' ').append(subquerySourceAlias);
                        this.generateJoiningExpression(incomingDB, sourceAlias, subquerySourceAlias);
                    }
                    this.context.append(" JOIN ");
                    this.context.append(subqueryTargetTableName).append(' ').append(subqueryTargetAlias);
                    this.generateJoiningExpression(dbRelationship, subquerySourceAlias, subqueryTargetAlias);
                }
            } else {
                targetAlias = this.appendTable(rhsId);
                this.generateJoiningExpression(incomingDB, sourceAlias, targetAlias);
            }
        }
        finally {
            if (marker != null) {
                this.context.popMarker();
            }
        }
    }

    private void generateJoiningExpression(DbRelationship incomingDB, String sourceAlias, String targetAlias) {
        DbJoin dbJoin;
        this.context.append(" ON (");
        Iterator<DbJoin> it = incomingDB.getJoins().iterator();
        if (it.hasNext()) {
            dbJoin = it.next();
            this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
        }
        while (it.hasNext()) {
            this.context.append(", ");
            dbJoin = it.next();
            this.context.append(sourceAlias).append('.').append(dbJoin.getSourceName()).append(" = ").append(targetAlias).append('.').append(dbJoin.getTargetName());
        }
        this.context.append(")");
    }

    public String appendTable(EJBQLTableId id) {
        Expression qualifier;
        String alias;
        DbEntity dbEntity = id.getDbEntity(this.context);
        String tableName = dbEntity.getFullyQualifiedName();
        if (this.context.isUsingAliases()) {
            alias = this.context.getTableAlias(id.getEntityId(), tableName);
            this.context.append(' ').append(tableName).append(' ').append(alias);
            this.generateJoinsForFlattenedAttributes(id, alias);
        } else {
            this.context.append(' ').append(tableName);
            alias = tableName;
        }
        if (id.isPrimaryTable() && (qualifier = this.context.getEntityDescriptor(id.getEntityId()).getEntityQualifier()) != null) {
            EJBQLExpression ejbqlQualifier = this.ejbqlQualifierForEntityAndSubclasses(qualifier, id.getEntityId());
            this.context.pushMarker(this.context.makeWhereMarker(), true);
            this.context.append(" WHERE");
            this.context.popMarker();
            this.context.pushMarker(this.context.makeEntityQualifierMarker(), false);
            ejbqlQualifier.visit(this.context.getTranslatorFactory().getConditionTranslator(this.context));
            this.context.popMarker();
        }
        return alias;
    }

    private void generateJoinsForFlattenedAttributes(EJBQLTableId id, String alias) {
        String entityName = this.context.getEntityDescriptor(id.getEntityId()).getEntity().getName();
        boolean isProcessingOmitted = false;
        isProcessingOmitted = id.getDbPath() != null;
        String sourceExpression = this.context.getCompiledExpression().getSource();
        List<Object> resultSetMapping = this.context.getMetadata().getResultSetMapping();
        for (Object mapping : resultSetMapping) {
            if (!(mapping instanceof EntityResultSegment) || !entityName.equals(((EntityResultSegment)mapping).getClassDescriptor().getEntity().getName())) continue;
            isProcessingOmitted = true;
            break;
        }
        if (!isProcessingOmitted) {
            Collection<ObjAttribute> attributes = this.context.getEntityDescriptor(id.getEntityId()).getEntity().getAttributes();
            for (ObjAttribute objAttribute : attributes) {
                if (!objAttribute.isFlattened() || !sourceExpression.contains(id.getEntityId() + "." + objAttribute.getName())) continue;
                Iterator<CayenneMapEntry> dbPathIterator = objAttribute.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry next = dbPathIterator.next();
                    if (!(next instanceof DbRelationship)) continue;
                    DbRelationship rel = (DbRelationship)next;
                    this.context.append(" LEFT OUTER JOIN ");
                    String targetEntityName = ((DbEntity)rel.getTargetEntity()).getFullyQualifiedName();
                    String subqueryTargetAlias = this.context.getTableAlias(id.getEntityId(), targetEntityName);
                    this.context.append(targetEntityName).append(' ').append(subqueryTargetAlias);
                    this.generateJoiningExpression(rel, this.context.getTableAlias(id.getEntityId(), ((DbEntity)rel.getSourceEntity()).getFullyQualifiedName()), subqueryTargetAlias);
                }
            }
        }
    }

    private EJBQLExpression ejbqlQualifierForEntityAndSubclasses(Expression qualifier, String entityId) {
        String ejbqlChunk = qualifier.toEJBQL(entityId);
        EJBQLExpression expression = EJBQLParserFactory.getParser().parse("DELETE FROM DUMMY WHERE " + ejbqlChunk);
        final EJBQLExpression[] result = new EJBQLExpression[1];
        expression.visit(new EJBQLBaseVisitor(){

            public boolean visitWhere(EJBQLExpression expression) {
                result[0] = expression.getChild(0);
                return false;
            }
        });
        return result[0];
    }
}

