/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.trans.ProcedureTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ProcedureQuery;

class MySQLProcedureAction
extends ProcedureAction {
    public MySQLProcedureAction(ProcedureQuery query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            boolean firstResult = statement.execute();
            this.readProcedureOutParameters(statement, observer);
            if (firstResult) {
                this.processResultSet(statement, observer);
            } else if (!this.processUpdate(statement, observer)) {
                return;
            }
            while (true) {
                if (statement.getMoreResults()) {
                    this.processResultSet(statement, observer);
                    continue;
                }
                if (!this.processUpdate(statement, observer)) break;
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultSet(CallableStatement statement, OperationObserver observer) throws Exception {
        ResultSet rs = statement.getResultSet();
        try {
            RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
            this.readResultSet(rs, descriptor, this.query, observer);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {}
        }
    }

    private boolean processUpdate(CallableStatement statement, OperationObserver observer) throws Exception {
        int updateCount = statement.getUpdateCount();
        if (updateCount == -1) {
            return false;
        }
        QueryLogger.logUpdateCount(updateCount);
        observer.nextCount(this.query, updateCount);
        return true;
    }

    protected ProcedureTranslator createTranslator(Connection connection) {
        MySQLProcedureTranslator translator = new MySQLProcedureTranslator();
        translator.setAdapter(this.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.getEntityResolver());
        translator.setConnection(connection);
        return translator;
    }

    static class MySQLProcedureTranslator
    extends ProcedureTranslator {
        MySQLProcedureTranslator() {
        }

        protected String createSqlString() {
            String sql = super.createSqlString();
            if (sql.endsWith("}") && !sql.endsWith(")}")) {
                sql = sql.substring(0, sql.length() - 1) + "()}";
            }
            return sql;
        }
    }
}

