/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesDialog;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesModel;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;

public class SuperclassUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "cayenne.modeler.datamap.defaultprefs.superclass.radio";
    public static final String UNINIT_CONTROL = "cayenne.modeler.datamap.defaultprefs.superclassnull.radio";
    protected boolean clientUpdate;

    public SuperclassUpdateController(ProjectController mediator, DataMap dataMap, boolean clientUpdate) {
        super(mediator, dataMap);
        this.clientUpdate = clientUpdate;
    }

    public void startup() {
        DefaultsPreferencesDialog view = new DefaultsPreferencesDialog(ALL_CONTROL, UNINIT_CONTROL);
        view.setTitle("Update DataObjects Superclass");
        this.setView(view);
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID("cayenne.modeler.datamap.defaultprefs.update.button")) {
            this.updateSuperclass();
        } else {
            super.doHandleControl(control);
        }
    }

    protected void updateSuperclass() {
        boolean doAll = ((DefaultsPreferencesModel)this.getModel()).isAllEntities();
        String defaultSuperclass = this.getSuperclass();
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            if (!doAll && !Util.isEmptyString(this.getSuperClassName(entity)) || Util.nullSafeEquals(defaultSuperclass, this.getSuperClassName(entity))) continue;
            this.setSuperClassName(entity, defaultSuperclass);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, entity));
        }
        this.shutdown();
    }

    protected String getSuperclass() {
        return this.clientUpdate ? this.dataMap.getDefaultClientSuperclass() : this.dataMap.getDefaultSuperclass();
    }

    protected String getSuperClassName(ObjEntity entity) {
        return this.clientUpdate ? entity.getClientSuperClassName() : entity.getSuperClassName();
    }

    protected void setSuperClassName(ObjEntity entity, String superClassName) {
        if (this.clientUpdate) {
            entity.setClientSuperClassName(superClassName);
        } else {
            entity.setSuperClassName(superClassName);
        }
    }
}

