/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ProcedureParameterTab;
import org.apache.cayenne.modeler.editor.ProcedureTab;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayListener;

public class ProcedureTabbedView
extends JTabbedPane
implements ProcedureDisplayListener,
ProcedureParameterDisplayListener {
    protected ProjectController eventController;
    protected ProcedureTab procedurePanel;
    protected ProcedureParameterTab procedureParameterPanel;

    public ProcedureTabbedView(ProjectController eventController) {
        this.eventController = eventController;
        this.setTabPlacement(1);
        this.procedurePanel = new ProcedureTab(eventController);
        this.addTab("Procedure", new JScrollPane(this.procedurePanel));
        this.procedureParameterPanel = new ProcedureParameterTab(eventController);
        this.addTab("Parameters", this.procedureParameterPanel);
        eventController.addProcedureDisplayListener(this);
        eventController.addProcedureParameterDisplayListener(this);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component selected = ProcedureTabbedView.this.getSelectedComponent();
                while (selected instanceof JScrollPane) {
                    selected = ((JScrollPane)selected).getViewport().getView();
                }
                ((ExistingSelectionProcessor)((Object)selected)).processExistingSelection(e);
            }
        });
    }

    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        Application.getInstance().getAction(RemoveProcedureParameterAction.getActionName()).setEnabled(false);
        if (e.getProcedure() == null) {
            this.setVisible(false);
        } else {
            if (e.isTabReset()) {
                this.setSelectedIndex(0);
            }
            this.setVisible(true);
        }
    }

    public void currentProcedureParameterChanged(ProcedureParameterDisplayEvent e) {
        ProcedureParameter[] parameters = e.getProcedureParameters();
        if (parameters.length > 0) {
            this.procedureParameterPanel.selectParameters(parameters);
        }
    }
}

