/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateDomainAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;
import org.apache.cayenne.query.Query;

public class RemoveUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private DbEntity dbEntity;
    private ObjEntity objEntity;
    private Query query;
    private Procedure procedure;
    private DataNode dataNode;
    private DataDomain domain;
    private Embeddable embeddable;
    private Map<DbEntity, List<DbRelationship>> dbRelationshipMap = new HashMap<DbEntity, List<DbRelationship>>();
    private Map<ObjEntity, List<ObjRelationship>> objRelationshipMap = new HashMap<ObjEntity, List<ObjRelationship>>();
    private REMOVE_MODE mode;

    public RemoveUndoableEdit(Application application, DataDomain domain) {
        this.domain = domain;
        this.mode = REMOVE_MODE.DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataNode node, DataMap map) {
        this.map = map;
        this.dataNode = node;
        this.mode = REMOVE_MODE.MAP_FROM_NODE;
    }

    public RemoveUndoableEdit(Application application, DataDomain domain, DataMap map) {
        this.domain = domain;
        this.map = map;
        this.mode = REMOVE_MODE.MAP_FROM_DOMAIN;
    }

    public RemoveUndoableEdit(Application application, DataDomain domain, DataNode node) {
        this.domain = domain;
        this.dataNode = node;
        this.mode = REMOVE_MODE.NODE;
    }

    public RemoveUndoableEdit(DataMap map, ObjEntity objEntity) {
        this.map = map;
        this.objEntity = objEntity;
        this.mode = REMOVE_MODE.OBJECT_ENTITY;
        for (ObjEntity ent : map.getObjEntities()) {
            for (Relationship relationship : new ArrayList<ObjRelationship>(ent.getRelationships())) {
                if (!this.objEntity.getName().equals(relationship.getTargetEntityName())) continue;
                ObjRelationship rel = (ObjRelationship)relationship;
                if (this.objRelationshipMap.get(rel.getSourceEntity()) == null) {
                    this.objRelationshipMap.put((ObjEntity)rel.getSourceEntity(), new LinkedList());
                }
                this.objRelationshipMap.get(rel.getSourceEntity()).add(rel);
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, DbEntity dbEntity) {
        this.map = map;
        this.dbEntity = dbEntity;
        this.mode = REMOVE_MODE.DB_ENTITY;
        for (ObjEntity objEnt : map.getObjEntities()) {
            block1: for (ObjRelationship rel : objEnt.getRelationships()) {
                for (DbRelationship dbRel : rel.getDbRelationships()) {
                    if (dbRel.getTargetEntity() != dbEntity) continue;
                    if (this.dbRelationshipMap.get(dbRel.getSourceEntity()) == null) {
                        this.dbRelationshipMap.put((DbEntity)dbRel.getSourceEntity(), new LinkedList());
                    }
                    this.dbRelationshipMap.get(dbRel.getSourceEntity()).add(dbRel);
                    continue block1;
                }
            }
        }
    }

    public RemoveUndoableEdit(DataMap map, Query query) {
        this.map = map;
        this.query = query;
        this.mode = REMOVE_MODE.QUERY;
    }

    public RemoveUndoableEdit(DataMap map, Procedure procedure) {
        this.map = map;
        this.procedure = procedure;
        this.mode = REMOVE_MODE.PROCEDURE;
    }

    public RemoveUndoableEdit(DataMap map, Embeddable embeddable) {
        this.map = map;
        this.embeddable = embeddable;
        this.mode = REMOVE_MODE.EMBEDDABLE;
    }

    public String getPresentationName() {
        switch (this.mode) {
            case OBJECT_ENTITY: {
                return "Remove Object Entity";
            }
            case DB_ENTITY: {
                return "Remove Db Entity";
            }
            case QUERY: {
                return "Remove Query";
            }
            case PROCEDURE: {
                return "Remove Procedure";
            }
            case MAP_FROM_NODE: {
                return "Remove DataMap";
            }
            case MAP_FROM_DOMAIN: {
                return "Remove DataMap";
            }
            case NODE: {
                return "Remove DataNode";
            }
            case DOMAIN: {
                return "Remove DataDomain";
            }
            case EMBEDDABLE: {
                return "Remove Embeddable";
            }
        }
        return "Remove";
    }

    public void redo() throws CannotRedoException {
        RemoveAction action = (RemoveAction)this.actionManager.getAction(RemoveAction.getActionName());
        switch (this.mode) {
            case OBJECT_ENTITY: {
                action.removeObjEntity(this.map, this.objEntity);
                break;
            }
            case DB_ENTITY: {
                action.removeDbEntity(this.map, this.dbEntity);
                break;
            }
            case QUERY: {
                action.removeQuery(this.map, this.query);
                break;
            }
            case PROCEDURE: {
                action.removeProcedure(this.map, this.procedure);
            }
            case MAP_FROM_NODE: {
                action.removeDataMapFromDataNode(this.dataNode, this.map);
                break;
            }
            case MAP_FROM_DOMAIN: {
                action.removeDataMap(this.domain, this.map);
                break;
            }
            case NODE: {
                action.removeDataNode(this.domain, this.dataNode);
                break;
            }
            case DOMAIN: {
                action.removeDomain(this.domain);
                break;
            }
            case EMBEDDABLE: {
                action.removeEmbeddable(this.map, this.embeddable);
            }
        }
    }

    public void undo() throws CannotUndoException {
        CreateRelationshipAction relationshipAction = (CreateRelationshipAction)this.actionManager.getAction(CreateRelationshipAction.getActionName());
        switch (this.mode) {
            case OBJECT_ENTITY: {
                for (Map.Entry<ObjEntity, List<ObjRelationship>> entry : this.objRelationshipMap.entrySet()) {
                    ObjEntity objEntity = entry.getKey();
                    for (ObjRelationship rel : entry.getValue()) {
                        relationshipAction.createObjRelationship(objEntity, rel);
                    }
                }
                CreateObjEntityAction action = (CreateObjEntityAction)this.actionManager.getAction(CreateObjEntityAction.getActionName());
                action.createObjEntity(this.map, this.objEntity);
                break;
            }
            case DB_ENTITY: {
                for (Map.Entry<DbEntity, List<DbRelationship>> entry : this.dbRelationshipMap.entrySet()) {
                    DbEntity dbEntity = entry.getKey();
                    for (DbRelationship rel : entry.getValue()) {
                        relationshipAction.createDbRelationship(dbEntity, rel);
                    }
                }
                CreateDbEntityAction action = (CreateDbEntityAction)this.actionManager.getAction(CreateDbEntityAction.getActionName());
                action.createEntity(this.map, this.dbEntity);
                break;
            }
            case QUERY: {
                this.domain = Application.getInstance().getFrameController().getProjectController().findDomain(this.map);
                CreateQueryAction action = (CreateQueryAction)this.actionManager.getAction(CreateQueryAction.getActionName());
                action.createQuery(this.domain, this.map, this.query);
                break;
            }
            case PROCEDURE: {
                CreateProcedureAction action = (CreateProcedureAction)this.actionManager.getAction(CreateProcedureAction.getActionName());
                action.createProcedure(this.map, this.procedure);
                break;
            }
            case MAP_FROM_NODE: {
                this.dataNode.addDataMap(this.map);
                DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), this.dataNode);
                ProjectController controller = Application.getInstance().getFrameController().getProjectController();
                e.setDomain(controller.findDomain(this.dataNode));
                controller.fireDataNodeEvent(e);
                break;
            }
            case MAP_FROM_DOMAIN: {
                CreateDataMapAction action = (CreateDataMapAction)this.actionManager.getAction(CreateDataMapAction.getActionName());
                action.createDataMap(this.domain, this.map);
                break;
            }
            case NODE: {
                CreateNodeAction action = (CreateNodeAction)this.actionManager.getAction(CreateNodeAction.getActionName());
                action.createDataNode(this.domain, this.dataNode);
                break;
            }
            case DOMAIN: {
                CreateDomainAction action = (CreateDomainAction)this.actionManager.getAction(CreateDomainAction.getActionName());
                action.createDomain(this.domain);
                break;
            }
            case EMBEDDABLE: {
                CreateEmbeddableAction action = (CreateEmbeddableAction)this.actionManager.getAction(CreateEmbeddableAction.getActionName());
                action.createEmbeddable(this.map, this.embeddable);
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum REMOVE_MODE {
        OBJECT_ENTITY,
        DB_ENTITY,
        QUERY,
        PROCEDURE,
        MAP_FROM_NODE,
        MAP_FROM_DOMAIN,
        NODE,
        DOMAIN,
        EMBEDDABLE;

    }
}

