/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class EmbeddableAttributeValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        EmbeddableAttribute emAttribute = (EmbeddableAttribute)path.getObject();
        if (Util.isEmptyString(emAttribute.getName())) {
            validator.registerError("Unnamed ObjAttribute.", path);
        }
        if (path.getObjectParent() != null && path.getObjectParent() != emAttribute.getEmbeddable()) {
            return;
        }
        if (Util.isEmptyString(emAttribute.getType())) {
            validator.registerWarning("EmbeddableAttribute has no type.", path);
        }
    }
}

