/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.util.ToStringBuilder;

public abstract class AbstractQuery
implements Query {
    protected Object root;
    protected String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        BaseQueryMetadata md = new BaseQueryMetadata();
        md.resolve(this.getRoot(), resolver, this.getName());
        return md;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object value) {
        if (value == null) {
            this.root = null;
        }
        if (!(value instanceof String || value instanceof ObjEntity || value instanceof DbEntity || value instanceof Class || value instanceof Procedure || value instanceof DataMap)) {
            String rootClass = value != null ? value.getClass().getName() : "null";
            throw new IllegalArgumentException(this.getClass().getName() + ": \"setRoot(..)\" takes a DataMap, String, ObjEntity, DbEntity, Procedure, " + "or Class. It was passed a " + rootClass);
        }
        this.root = value;
    }

    public String toString() {
        return new ToStringBuilder(this).append("root", this.root).append("name", this.getName()).toString();
    }

    public abstract SQLAction createSQLAction(SQLActionVisitor var1);

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        DataMap map = this.getMetaData(resolver).getDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap found, can't route query " + this);
        }
        router.route(router.engineForDataMap(map), this, substitutedQuery);
    }
}

