/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;

abstract class DataObjectBaseProperty
implements Property {
    DataObjectBaseProperty() {
    }

    public abstract String getName();

    public abstract void injectValueHolder(Object var1) throws PropertyException;

    public abstract boolean visit(PropertyVisitor var1);

    public Object readProperty(Object object) throws PropertyException {
        try {
            return this.toDataObject(object).readProperty(this.getName());
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading DataObject property: " + this.getName(), this, object, th);
        }
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyException {
        try {
            this.toDataObject(object).writeProperty(this.getName(), newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing DataObject property: " + this.getName(), this, object, th);
        }
    }

    public Object readPropertyDirectly(Object object) throws PropertyException {
        try {
            return this.toDataObject(object).readPropertyDirectly(this.getName());
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading DataObject property: " + this.getName(), this, object, th);
        }
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyException {
        try {
            this.toDataObject(object).writePropertyDirectly(this.getName(), newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing DataObject property: " + this.getName(), this, object, th);
        }
    }

    protected final DataObject toDataObject(Object object) throws PropertyException {
        try {
            return (DataObject)object;
        }
        catch (ClassCastException e) {
            throw new PropertyException("Object is not a DataObject: '" + object.getClass().getName() + "'", this, object, (Throwable)e);
        }
    }
}

