/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.sql.Driver;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;

public class DbGeneratorTask
extends CayenneTask {
    protected boolean dropTables;
    protected boolean dropPK;
    protected boolean createTables = true;
    protected boolean createPK = true;
    protected boolean createFK = true;

    public void execute() {
        if (this.adapter == null) {
            this.adapter = new JdbcAdapter();
        }
        this.log(String.format("connection settings - [driver: %s, url: %s, username: %s]", this.driver, this.url, this.userName), 3);
        this.log(String.format("generator options - [dropTables: %s, dropPK: %s, createTables: %s, createPK: %s, createFK: %s]", this.dropTables, this.dropPK, this.createTables, this.createPK, this.createFK), 3);
        this.validateAttributes();
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DbGeneratorTask.class.getClassLoader());
            DataMap dataMap = this.loadDataMap();
            DbGenerator generator = new DbGenerator(this.adapter, dataMap);
            generator.setShouldCreateFKConstraints(this.createFK);
            generator.setShouldCreatePKSupport(this.createPK);
            generator.setShouldCreateTables(this.createTables);
            generator.setShouldDropPKSupport(this.dropPK);
            generator.setShouldDropTables(this.dropTables);
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.userName, this.password);
            generator.runGenerator(dataSource);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException(ex);
            String message = "Error generating database";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.log(message, 0);
            throw new BuildException(message, th);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected void validateAttributes() throws BuildException {
        StringBuilder error = new StringBuilder("");
        if (this.map == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if (this.driver == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (this.url == null) {
            error.append("The 'adapter' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setCreateFK(boolean createFK) {
        this.createFK = createFK;
    }

    public void setCreatePK(boolean createPK) {
        this.createPK = createPK;
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public void setDropPK(boolean dropPK) {
        this.dropPK = dropPK;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }
}

