/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;

public class ArrayModel
extends BasicModel
implements List {
    public static final Selector ARRAY = Selector.fromString("array");
    private static final String TO_STRING_SEPARATOR = ", ";
    private static final int TO_STRING_SEPARATOR_LENGTH = ", ".length();
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$model$collection$ArrayModel == null ? (class$org$scopemvc$model$collection$ArrayModel = ArrayModel.class$("org.scopemvc.model.collection.ArrayModel")) : class$org$scopemvc$model$collection$ArrayModel);
    private Object[] contents;
    private boolean propagateModelChanges;
    static /* synthetic */ Class class$org$scopemvc$model$collection$ArrayModel;

    public ArrayModel() {
        this(true);
    }

    public ArrayModel(Object[] objectArray) {
        this(true);
        this.setArray(objectArray);
    }

    public ArrayModel(int n) {
        this(true, n);
    }

    public ArrayModel(boolean bl) {
        this.propagateModelChanges = bl;
    }

    public ArrayModel(boolean bl, int n) {
        this(bl);
        if (n < 0) {
            throw new IllegalArgumentException("Can't create ArrayModel with size < 0: " + n);
        }
        this.setArray(new Object[n]);
    }

    public ArrayModel(boolean bl, Object[] objectArray) {
        this(bl);
        this.setArray(objectArray);
    }

    public Object[] getArray() {
        return this.contents;
    }

    public int getSize() {
        return this.size();
    }

    public int getIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        int n = 0;
        while (n < this.getSize()) {
            if (object.equals(this.contents[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.contents == null || this.contents.length < 1;
    }

    public Object get(int n) {
        return this.contents[n];
    }

    public void setArray(Object[] objectArray) {
        Object object;
        int n;
        if (this.propagateModelChanges && this.contents != null) {
            n = 0;
            while (n < this.contents.length) {
                object = this.contents[n];
                if (object instanceof ModelChangeEventSource) {
                    ((ModelChangeEventSource)object).removeModelChangeListener(this);
                }
                ++n;
            }
        }
        this.contents = objectArray;
        if (this.propagateModelChanges && this.contents != null) {
            n = 0;
            while (n < this.contents.length) {
                object = this.contents[n];
                if (object != null && object instanceof ModelChangeEventSource) {
                    ((ModelChangeEventSource)object).addModelChangeListener(this);
                }
                ++n;
            }
        }
        this.fireModelChange(0, ARRAY);
    }

    public Object set(int n, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("set: " + n + TO_STRING_SEPARATOR + object);
        }
        Object object2 = this.get(n);
        this.contents[n] = object;
        this.fireModelChange(0, Selector.fromInt(n));
        if (this.propagateModelChanges) {
            if (object2 instanceof ModelChangeEventSource) {
                ((ModelChangeEventSource)object2).removeModelChangeListener(this);
            }
            if (object instanceof ModelChangeEventSource) {
                ((ModelChangeEventSource)object).addModelChangeListener(this);
            }
        }
        return object2;
    }

    public String toString() {
        if (this.contents == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < this.contents.length) {
            stringBuffer.append(this.contents[n] == null ? "[null]" : this.contents[n].toString());
            stringBuffer.append(TO_STRING_SEPARATOR);
            ++n;
        }
        if (this.contents.length > 0) {
            stringBuffer.setLength(stringBuffer.length() - TO_STRING_SEPARATOR_LENGTH);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return Arrays.asList(this.contents).iterator();
    }

    public int size() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.length;
    }

    public Object[] toArray(Object[] objectArray) {
        return Arrays.asList(this.contents).toArray(objectArray);
    }

    public boolean contains(Object object) {
        return Arrays.asList(this.contents).contains(object);
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        return this.contents;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        return Arrays.asList(this.contents).containsAll(collection);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        return this.contents.equals(object);
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object object) {
        return Arrays.asList(this.contents).lastIndexOf(object);
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int n) {
        return Arrays.asList(this.contents).listIterator(n);
    }

    public int indexOf(Object object) {
        return this.getIndexOf(object);
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.contents).listIterator();
    }

    public List subList(int n, int n2) {
        return Arrays.asList(this.contents).subList(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

