/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.Selector;
import org.scopemvc.model.basic.BasicModel;

public class SetModel
extends BasicModel
implements Set {
    public static final Selector SET = Selector.fromString("set");
    protected static final String TO_STRING_SEPARATOR = ", ";
    protected static final int TO_STRING_SEPARATOR_LENGTH = ", ".length();
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$model$collection$ListModel == null ? (class$org$scopemvc$model$collection$ListModel = SetModel.class$("org.scopemvc.model.collection.ListModel")) : class$org$scopemvc$model$collection$ListModel);
    protected Set contents;
    protected boolean propagateModelChanges;
    static /* synthetic */ Class class$org$scopemvc$model$collection$ListModel;

    public SetModel() {
        this(true, new HashSet());
    }

    public SetModel(Set set) {
        this(true, set);
    }

    public SetModel(boolean bl) {
        this.propagateModelChanges = bl;
    }

    public SetModel(boolean bl, Set set) {
        this(bl);
        this.setSet(set);
    }

    public Set getSet() {
        return this.contents;
    }

    public int getSize() {
        if (this.contents == null) {
            return 0;
        }
        return this.contents.size();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public void setSet(Set set) {
        Object e;
        Iterator iterator;
        if (this.propagateModelChanges && this.contents != null) {
            iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ModelChangeEventSource)) continue;
                ((ModelChangeEventSource)e).removeModelChangeListener(this);
            }
        }
        this.contents = set;
        if (this.propagateModelChanges && this.contents != null) {
            iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ModelChangeEventSource)) continue;
                ((ModelChangeEventSource)e).addModelChangeListener(this);
            }
        }
        this.fireModelChange(0, SET);
    }

    public void modelChanged(ModelChangeEvent modelChangeEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("modelChanged: " + modelChangeEvent);
        }
        this.fireModelChange(0, null);
    }

    public String toString() {
        if (this.contents == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        Iterator iterator = this.contents.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append(e == null ? "<null>" : e.toString());
            stringBuffer.append(TO_STRING_SEPARATOR);
        }
        if (this.contents.size() > 0) {
            stringBuffer.setLength(stringBuffer.length() - TO_STRING_SEPARATOR_LENGTH);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public int size() {
        return this.contents.size();
    }

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public Iterator iterator() {
        return this.contents.iterator();
    }

    public Object[] toArray() {
        return this.contents.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.contents.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.contents.containsAll(collection);
    }

    public boolean add(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("add: " + object);
        }
        if (!this.contents.add(object)) {
            return false;
        }
        if (this.propagateModelChanges && object instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)object).addModelChangeListener(this);
        }
        this.fireModelChange(1, null);
        return true;
    }

    public boolean remove(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + object);
        }
        if (!this.contents.remove(object)) {
            return false;
        }
        if (this.propagateModelChanges && object instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)object).removeModelChangeListener(this);
        }
        this.fireModelChange(2, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.add(iterator.next());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        HashSet hashSet = new HashSet(this.contents);
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                this.remove(e);
                bl = true;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean bl = false;
        this.makeActive(false);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.remove(iterator.next());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.makeActive(false);
        try {
            if (this.propagateModelChanges) {
                Iterator iterator = this.contents.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof ModelChangeEventSource)) continue;
                    ((ModelChangeEventSource)e).removeModelChangeListener(this);
                }
            }
            this.contents.clear();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.makeActive(true);
            throw throwable;
        }
        this.makeActive(true);
        this.fireModelChange(0, null);
    }

    public boolean equals(Object object) {
        return this.contents.equals(object);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

