/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.servlet.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.util.ScopeConfig;
import org.scopemvc.view.servlet.Page;
import org.xml.sax.ContentHandler;

public abstract class AbstractXSLPage
extends Page {
    protected static HashMap templateCache = new HashMap();
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$servlet$xml$AbstractXSLPage == null ? (class$org$scopemvc$view$servlet$xml$AbstractXSLPage = AbstractXSLPage.class$("org.scopemvc.view.servlet.xml.AbstractXSLPage")) : class$org$scopemvc$view$servlet$xml$AbstractXSLPage);
    private static String systemID;
    protected boolean shouldCacheTemplates;
    protected String xslURI;
    protected String debugXMLDirectory;
    static /* synthetic */ Class class$org$scopemvc$view$servlet$xml$AbstractXSLPage;

    public AbstractXSLPage(String string, String string2) {
        super(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug("XslURI: " + string2);
        }
        this.setXslURI(string2);
        this.shouldCacheTemplates = ScopeConfig.getString("org.scopemvc.view.servlet.xml.AbstractXSLPage.shouldCacheTemplates").equals("1");
        this.debugXMLDirectory = ScopeConfig.getString("org.scopemvc.view.servlet.xml.AbstractXSLPage.debugXMLDirectory");
        if (this.debugXMLDirectory.length() < 1) {
            this.debugXMLDirectory = null;
        }
    }

    public static String getSystemID() {
        if (systemID == null) {
            return "";
        }
        return systemID;
    }

    public static void setSystemID(String string) {
        systemID = string;
    }

    public String getXslURI() {
        return this.xslURI;
    }

    public String getContentType() {
        if (this.getXslURI() == null) {
            return "text/xml";
        }
        return "text/html";
    }

    public void setXslURI(String string) {
        this.xslURI = string;
    }

    public String toString() {
        String string = "(" + this.getClass().getName() + ":" + this.getID() + "," + AbstractXSLPage.getSystemID() + "," + this.getXslURI();
        string = string + ")";
        return string;
    }

    public void streamView(OutputStream outputStream) throws Exception {
        Object object;
        if (this.debugXMLDirectory != null) {
            try {
                object = new File(this.debugXMLDirectory + this.getXslURI() + ".xml");
                File file = ((File)object).getParentFile();
                file.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                this.generateXMLDocument(this.makeSerializer(fileOutputStream, this.getXMLOutputProperties()));
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.warn("streamView: can't write XML to file: ", iOException);
            }
        }
        object = this.getTransformerHandler(outputStream);
        long l = System.currentTimeMillis();
        this.generateXMLDocument((ContentHandler)object);
        if (LOG.isInfoEnabled()) {
            LOG.info("streamView: process XML: time: " + (System.currentTimeMillis() - l));
        }
    }

    protected Properties getXMLOutputProperties() {
        Properties properties = new Properties();
        properties.put("method", "xml");
        properties.put("indent", "2");
        return properties;
    }

    protected Properties getHTMLOutputProperties() {
        Properties properties = new Properties();
        properties.put("method", "html");
        properties.put("indent", "2");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransformerHandler getTransformerHandler(OutputStream outputStream) throws Exception {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new UnsupportedOperationException("Can't use AbstractXSLPage with an XSL Processor that can't output to SAX.");
        }
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            throw new UnsupportedOperationException("Can't use AbstractXSLPage with an XSL Processor that can't take SAX input.");
        }
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
        TransformerHandler transformerHandler = null;
        if (this.getXslURI() == null) {
            transformerHandler = sAXTransformerFactory.newTransformerHandler();
        } else {
            object2 = templateCache;
            synchronized (object2) {
                object = templateCache.get(this.getXslURI());
            }
            Templates templates = null;
            if (object != null) {
                templates = (Templates)object;
            } else {
                String string = AbstractXSLPage.getSystemID() + this.getXslURI();
                URL uRL = new URL(string);
                if (LOG.isInfoEnabled()) {
                    LOG.info("XSL URL: " + uRL);
                }
                InputStream inputStream = uRL.openStream();
                int n = string.lastIndexOf(47) + 1;
                String string2 = "";
                if (n >= 0) {
                    string2 = string.substring(0, n);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getTransformerHandler: baseURI: " + string2 + "urlPath: " + string);
                }
                StreamSource streamSource = new StreamSource(inputStream, string2);
                templates = sAXTransformerFactory.newTemplates(streamSource);
                if (this.shouldCacheTemplates) {
                    HashMap hashMap = templateCache;
                    synchronized (hashMap) {
                        templateCache.put(this.getXslURI(), templates);
                    }
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("getTransformerHandler: get compiled XSL: time: " + (System.currentTimeMillis() - l));
            }
            transformerHandler = sAXTransformerFactory.newTransformerHandler(templates);
        }
        object = this.getXslURI() == null ? this.makeSerializer(outputStream, this.getXMLOutputProperties()) : this.makeSerializer(outputStream, this.getHTMLOutputProperties());
        object2 = new SAXResult((ContentHandler)object);
        transformerHandler.setResult((Result)object2);
        return transformerHandler;
    }

    protected ContentHandler makeSerializer(OutputStream outputStream, Properties properties) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
                Transformer transformer = transformerHandler.getTransformer();
                transformer.setOutputProperties(properties);
                StreamResult streamResult = new StreamResult(outputStream);
                transformerHandler.setResult(streamResult);
                return transformerHandler;
            }
            LOG.fatal("TransformerFactory doesn't support SAXSource");
            throw new UnsupportedOperationException("TransformerFactory doesn't support SAXSource");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOG.fatal("TransformerConfigurationException", transformerConfigurationException);
            throw new UnsupportedOperationException("TransformerConfigurationException: " + transformerConfigurationException);
        }
    }

    protected abstract void generateXMLDocument(ContentHandler var1) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

