/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.view.swing.SSortTable;
import org.scopemvc.view.swing.STableModel;

public class SSortTableModel
extends STableModel
implements TableModelListener {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SSortTableModel == null ? (class$org$scopemvc$view$swing$SSortTableModel = SSortTableModel.class$("org.scopemvc.view.swing.SSortTableModel")) : class$org$scopemvc$view$swing$SSortTableModel);
    private int[] indexes = new int[0];
    private int[] sortingColumns;
    private boolean ascending = true;
    private int compares;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SSortTableModel;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;

    public SSortTableModel(JTable jTable) {
        super(jTable);
        this.addTableModelListener(this);
    }

    public Object getValueAt(int n, int n2) {
        this.checkModel();
        return super.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        super.setValueAt(object, this.indexes[n], n2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("tableChanged: event = " + tableModelEvent);
        }
        if (this.indexes.length != (n = this.getRowCount())) {
            if (tableModelEvent.getType() == 1 && tableModelEvent.getFirstRow() == n - 1 && tableModelEvent.getFirstRow() == tableModelEvent.getLastRow()) {
                int[] nArray = new int[n];
                System.arraycopy(this.indexes, 0, nArray, 0, this.indexes.length);
                nArray[n - 1] = n - 1;
                this.indexes = nArray;
            } else if (tableModelEvent.getType() == -1 && tableModelEvent.getFirstRow() == tableModelEvent.getLastRow()) {
                int[] nArray = new int[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.indexes.length) {
                    if (this.indexes[n3] != tableModelEvent.getFirstRow()) {
                        nArray[n2] = this.indexes[n3] >= tableModelEvent.getFirstRow() ? this.indexes[n3] - 1 : this.indexes[n3];
                        ++n2;
                    }
                    ++n3;
                }
                this.indexes = nArray;
            } else {
                this.reallocateIndexes();
            }
        }
    }

    public void sort() {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public int convertRowIndexToModel(int n) {
        return this.indexes[n];
    }

    public int convertModelIndexToView(int n) {
        int n2 = 0;
        while (n2 < this.indexes.length) {
            if (this.indexes[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortByColumns(new int[]{n}, bl);
    }

    public void sortByColumns(int[] nArray, boolean bl) {
        this.ascending = bl;
        this.sortingColumns = nArray;
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected int compareRowsByColumn(int n, int n2, int n3) {
        Object object = super.getValueAt(n, n3);
        Object object2 = super.getValueAt(n2, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable && object2 instanceof Comparable) {
            int n4 = ((Comparable)object).compareTo(object2);
            return this.normalizeResult(n4);
        }
        if (this.getColumnClass(n3).getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = SSortTableModel.class$("java.lang.Number")) : class$java$lang$Number)) {
            Number number;
            double d;
            Number number2 = (Number)super.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)super.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (this.getColumnClass(n3) == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SSortTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)super.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)super.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object3 = super.getValueAt(n, n3);
        String string = object3.toString();
        Object object4 = super.getValueAt(n2, n3);
        String string2 = object4.toString();
        int n5 = string.compareTo(string2);
        return this.normalizeResult(n5);
    }

    protected int compare(int n, int n2) {
        ++this.compares;
        int n3 = 0;
        while (n3 < this.sortingColumns.length) {
            int n4 = this.compareRowsByColumn(n, n2, this.sortingColumns[n3]);
            if (n4 != 0) {
                return this.ascending ? n4 : -n4;
            }
            ++n3;
        }
        return 0;
    }

    protected void reallocateIndexes() {
        int n = this.getRowCount();
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n2;
            ++n2;
        }
        if (this.getTable() instanceof SSortTable) {
            SSortTable sSortTable = (SSortTable)this.getTable();
            sSortTable.resetHeader();
        }
    }

    protected void checkModel() {
        if (this.indexes.length != this.getRowCount()) {
            LOG.warn("Sorter not informed of a change in model.");
        }
    }

    protected void n2sort() {
        int n = 0;
        while (n < this.getRowCount()) {
            int n2 = n + 1;
            while (n2 < this.getRowCount()) {
                if (this.compare(this.indexes[n], this.indexes[n2]) == -1) {
                    this.swap(n, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    private int normalizeResult(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    private void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

