/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.event.EntityListenerEvent;

public class RemoveEntityListenerAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove entity listener";

    public RemoveEntityListenerAction(Application application) {
        super(RemoveEntityListenerAction.getActionName(), application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getIconName() {
        return "icon-remove-listener.gif";
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (this.getProjectController().getCurrentObjEntity() != null && this.getProjectController().getCurrentListenerClass() != null && dialog.shouldDelete("entity listener", this.getProjectController().getCurrentListenerClass())) {
            ObjEntity objEnt = this.getProjectController().getCurrentObjEntity();
            String listenerClass = this.getProjectController().getCurrentListenerClass();
            this.removeEntityListener(objEnt, listenerClass);
        }
    }

    public void removeEntityListener(ObjEntity objEnt, String listenerClass) {
        objEnt.removeEntityListener(listenerClass);
        this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listenerClass, listenerClass, 3));
    }
}

