/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.ProcedureParameterEvent;
import org.apache.cayenne.map.event.ProcedureParameterListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CutProcedureParameterAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ProcedureParameterTableModel;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.util.CayenneCellEditor;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ProcedureParameterTab
extends JPanel
implements ProcedureParameterListener,
ProcedureDisplayListener,
ExistingSelectionProcessor,
ActionListener {
    protected ProjectController eventController;
    protected CayenneTable table;
    protected JButton removeParameterButton;
    protected JButton moveUp;
    protected JButton moveDown;
    protected JMenuItem removeParameterMenu;
    protected JMenuItem moveUpMenu;
    protected JMenuItem moveDownMenu;

    public ProcedureParameterTab(ProjectController eventController) {
        this.eventController = eventController;
        this.init();
        eventController.addProcedureDisplayListener(this);
        eventController.addProcedureParameterListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProcedureParameterTab.this.processExistingSelection(e);
            }
        });
        this.moveDown.addActionListener(this);
        this.moveUp.addActionListener(this);
        this.moveDownMenu.addActionListener(this);
        this.moveUpMenu.addActionListener(this);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateProcedureParameterAction.getActionName()).buildButton());
        this.removeParameterButton = app.getAction(RemoveProcedureParameterAction.getActionName()).buildButton();
        toolBar.add(this.removeParameterButton);
        toolBar.addSeparator();
        ImageIcon up = ModelerUtil.buildIcon("icon-move_up.gif");
        ImageIcon down = ModelerUtil.buildIcon("icon-move_down.gif");
        this.moveUp = new JButton();
        this.moveUp.setIcon(up);
        this.moveUp.setToolTipText("Move Parameter Up");
        toolBar.add(this.moveUp);
        this.moveDown = new JButton();
        this.moveDown.setIcon(down);
        this.moveDown.setToolTipText("Move Parameter Down");
        toolBar.add(this.moveDown);
        toolBar.addSeparator();
        toolBar.add(app.getAction(CutProcedureParameterAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CopyProcedureParameterAction.getActionName()).buildButton());
        toolBar.add(app.getAction(PasteAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        JPopupMenu popup = new JPopupMenu();
        this.removeParameterMenu = app.getAction(RemoveProcedureParameterAction.getActionName()).buildMenu();
        popup.add(this.removeParameterMenu);
        popup.addSeparator();
        this.moveUpMenu = new JMenuItem("Move Parameter Up", up);
        this.moveDownMenu = new JMenuItem("Move Parameter Down", down);
        popup.add(this.moveUpMenu);
        popup.add(this.moveDownMenu);
        popup.addSeparator();
        popup.add(app.getAction(CutProcedureParameterAction.getActionName()).buildMenu());
        popup.add(app.getAction(CopyProcedureParameterAction.getActionName()).buildMenu());
        popup.add(app.getAction(PasteAction.getActionName()).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
        this.eventController.getApplication().getActionManager().setupCCP(this.table, CutProcedureParameterAction.getActionName(), CopyProcedureParameterAction.getActionName());
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        ProcedureParameter[] parameters = new ProcedureParameter[]{};
        boolean enableUp = false;
        boolean enableDown = false;
        boolean enableRemoveButton = false;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            enableRemoveButton = true;
            ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            parameters = new ProcedureParameter[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                parameters[i] = model.getParameter(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
                int rowCount = this.table.getRowCount();
                if (rowCount > 1) {
                    if (selectedRow > 0) {
                        enableUp = true;
                    }
                    if (selectedRow < rowCount - 1) {
                        enableDown = true;
                    }
                }
            }
        }
        this.removeParameterButton.setEnabled(enableRemoveButton);
        this.moveUp.setEnabled(enableUp);
        this.moveDown.setEnabled(enableDown);
        this.syncButtons();
        ProcedureParameterDisplayEvent ppde = new ProcedureParameterDisplayEvent((Object)this, parameters, this.eventController.getCurrentProcedure(), this.eventController.getCurrentDataMap(), this.eventController.getCurrentDataDomain());
        this.eventController.fireProcedureParameterDisplayEvent(ppde);
    }

    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        Procedure procedure = e.getProcedure();
        if (procedure != null && e.isProcedureChanged()) {
            this.rebuildTable(procedure);
        }
    }

    public void selectParameters(ProcedureParameter[] parameters) {
        ModelerUtil.updateActions(parameters.length, RemoveProcedureParameterAction.getActionName(), CutProcedureParameterAction.getActionName(), CopyProcedureParameterAction.getActionName());
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            newSel[i] = listAttrs.indexOf(parameters[i]);
        }
        this.table.select(newSel);
    }

    protected void rebuildTable(Procedure procedure) {
        ProcedureParameterTableModel model = new ProcedureParameterTableModel(procedure, this.eventController, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn numberColumn = this.table.getColumnModel().getColumn(0);
        numberColumn.setPreferredWidth(35);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        numberColumn.setCellRenderer(renderer);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(1);
        nameColumn.setMinWidth(150);
        TableColumn typesColumn = this.table.getColumnModel().getColumn(3);
        typesColumn.setMinWidth(90);
        JComboBox typesEditor = CayenneWidgetFactory.createComboBox(TypesMapping.getDatabaseTypes(), true);
        AutoCompletion.enable(typesEditor);
        typesColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(typesEditor));
        TableColumn directionColumn = this.table.getColumnModel().getColumn(2);
        directionColumn.setMinWidth(90);
        JComboBox directionEditor = CayenneWidgetFactory.createComboBox(ProcedureParameterTableModel.PARAMETER_DIRECTION_NAMES, false);
        directionEditor.setEditable(false);
        directionColumn.setCellEditor(new CayenneCellEditor(directionEditor));
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
    }

    public void procedureParameterAdded(ProcedureParameterEvent e) {
        this.rebuildTable(e.getParameter().getProcedure());
        this.table.select(e.getParameter());
    }

    public void procedureParameterChanged(ProcedureParameterEvent e) {
        this.table.select(e.getParameter());
    }

    public void procedureParameterRemoved(ProcedureParameterEvent e) {
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getParameter());
        model.removeRow(e.getParameter());
        this.table.select(ind);
    }

    public void actionPerformed(ActionEvent e) {
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        ProcedureParameter parameter = model.getParameter(this.table.getSelectedRow());
        int index = -1;
        if (e.getSource() == this.moveUp || e.getSource() == this.moveUpMenu) {
            index = model.moveRowUp(parameter);
        } else if (e.getSource() == this.moveDown || e.getSource() == this.moveDownMenu) {
            index = model.moveRowDown(parameter);
        }
        if (index >= 0) {
            this.table.select(index);
            parameter.getProcedure().setCallParameters(model.getObjectList());
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, parameter.getProcedure(), 1));
        }
    }

    private void syncButtons() {
        this.removeParameterMenu.setEnabled(this.removeParameterButton.isEnabled());
        this.moveUpMenu.setEnabled(this.moveUp.isEnabled());
        this.moveDownMenu.setEnabled(this.moveDown.isEnabled());
    }
}

