/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.cayenne.swing.ActionDelegate;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.BindingFactory;
import org.apache.cayenne.swing.BoundComponent;
import org.apache.cayenne.swing.ObjectBinding;

public class BindingBuilder {
    protected BindingFactory factory;
    protected BindingDelegate delegate;
    protected Object context;
    protected Map actionsMap;

    public BindingBuilder(BindingFactory factory, Object context) {
        this.factory = factory;
        this.context = context;
    }

    public BindingDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(BindingDelegate delegate) {
        this.delegate = delegate;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public BindingFactory getFactory() {
        return this.factory;
    }

    public ObjectBinding bindToProperty(BoundComponent component, String property, String boundProperty) {
        ObjectBinding binding = this.factory.bindToProperty(component, property, boundProperty);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToAction(BoundComponent component, String action, String boundProperty) {
        ObjectBinding binding = this.factory.bindToAction(component, action, boundProperty);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToStateChange(AbstractButton button, String property) {
        ObjectBinding binding = this.factory.bindToStateChange(button, property);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToStateChangeAndAction(AbstractButton button, String property, String action) {
        ObjectBinding binding = this.factory.bindToStateChange(button, property);
        return this.initBinding(binding, this.getActionDelegate(action));
    }

    public ObjectBinding bindToAction(AbstractButton button, String action) {
        ObjectBinding binding = this.factory.bindToAction(button, action);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToAction(Component component, String action) {
        ObjectBinding binding = this.factory.bindToAction(component, action);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToComboSelection(JComboBox component, String property) {
        ObjectBinding binding = this.factory.bindToComboSelection(component, property, null);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToComboSelection(JComboBox component, String property, String noSelectionValue) {
        ObjectBinding binding = this.factory.bindToComboSelection(component, property, noSelectionValue);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToComboSelection(JComboBox component, String property, String action, String noSelectionValue) {
        ObjectBinding binding = this.factory.bindToComboSelection(component, property, noSelectionValue);
        return this.initBinding(binding, this.getActionDelegate(action));
    }

    public ObjectBinding bindToTextArea(JTextArea component, String property) {
        ObjectBinding binding = this.factory.bindToTextArea(component, property);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToTextField(JTextField component, String property) {
        ObjectBinding binding = this.factory.bindToTextField(component, property);
        return this.initBinding(binding, this.delegate);
    }

    public ObjectBinding bindToCheckBox(JCheckBox component, String property) {
        ObjectBinding binding = this.factory.bindToCheckBox(component, property);
        return this.initBinding(binding, this.delegate);
    }

    protected ObjectBinding initBinding(ObjectBinding binding, BindingDelegate delegate) {
        binding.setDelegate(delegate);
        binding.setContext(this.context);
        return binding;
    }

    protected BindingDelegate getActionDelegate(String action) {
        BindingDelegate delegate = null;
        if (this.actionsMap == null) {
            this.actionsMap = new HashMap();
        } else {
            delegate = (BindingDelegate)this.actionsMap.get(action);
        }
        if (delegate == null) {
            delegate = new ActionDelegate(action);
            this.actionsMap.put(action, delegate);
        }
        return delegate;
    }
}

