/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.apache.cayenne.enhancer.DoubleEnhanceException;
import org.apache.cayenne.enhancer.EnhancerVisitorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enhancer
implements ClassFileTransformer {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected EnhancerVisitorFactory visitorFactory;

    public Enhancer(EnhancerVisitorFactory visitorFactory) {
        this.visitorFactory = visitorFactory;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(reader, 2);
        ClassVisitor visitor = this.visitorFactory.createVisitor(className, (ClassVisitor)writer);
        if (visitor == null) {
            return null;
        }
        this.logger.info((Object)("enhancing class " + className));
        try {
            reader.accept(visitor, 0);
        }
        catch (DoubleEnhanceException e) {
            this.logger.info((Object)("class already enhanced, skipping: " + className));
            return null;
        }
        return writer.toByteArray();
    }
}

