/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.jetbrains.annotations.NotNull;

public final class AccessControlEntry {
    private final boolean isAllow;
    private final List<String> privileges;
    private final RepoPath repositoryPath;
    private final List<RestrictionClause> restrictions = new LinkedList<RestrictionClause>();
    private final boolean isPrincipalBased;

    public AccessControlEntry(boolean isAllow, @NotNull List<String> privileges, @NotNull RepoPath repositoryPath) {
        this(isAllow, privileges, repositoryPath, false);
    }

    public AccessControlEntry(boolean isAllow, @NotNull List<String> privileges, @NotNull RepoPath repositoryPath, boolean isPrincipalBased) {
        this.isAllow = isAllow;
        this.privileges = privileges;
        this.repositoryPath = repositoryPath;
        this.isPrincipalBased = isPrincipalBased;
    }

    public void addRestriction(@NotNull String restrictionName, List<String> values) {
        if (!restrictionName.isEmpty()) {
            this.restrictions.add(new RestrictionClause(restrictionName, values));
        }
    }

    @NotNull
    public RepoPath getRepositoryPath() {
        return this.repositoryPath;
    }

    public boolean isPrincipalBased() {
        return this.isPrincipalBased;
    }

    @NotNull
    public AclLine asAclLine(@NotNull String path) {
        AclLine line = new AclLine(this.isAllow ? AclLine.Action.ALLOW : AclLine.Action.DENY);
        line.setProperty("paths", Collections.singletonList(path));
        line.setProperty("privileges", this.privileges);
        line.setRestrictions(this.restrictions);
        return line;
    }

    public String toString() {
        return "Acl [isAllow=" + this.isAllow + ", privileges=" + this.privileges + ", path=" + this.repositoryPath + ", restrictions=" + this.restrictions + ", isPrincipalBased=" + this.isPrincipalBased + "]";
    }
}

