/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.function.IOSupplier;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.FileInputSource;

public class SingleFileArchive
implements Archive {
    private final Path file;
    private final InputStream inputStream;
    private final IOSupplier<Path> tmpFileSupplier;
    private Path tmpFile;
    private final String relativePath;

    public static SingleFileArchive fromPathOrInputStream(Path path, InputStream inputStream, IOSupplier<Path> tmpFileSupplier, String relativePath) {
        if (path != null) {
            return new SingleFileArchive(path, relativePath);
        }
        if (inputStream != null) {
            return new SingleFileArchive(inputStream, tmpFileSupplier, relativePath);
        }
        throw new IllegalArgumentException("Either file or inputStream must be non-null!");
    }

    private SingleFileArchive(InputStream inputStream, IOSupplier<Path> tmpFileSupplier, String relativePath) {
        this.file = null;
        this.inputStream = inputStream;
        this.tmpFileSupplier = tmpFileSupplier;
        this.relativePath = relativePath;
    }

    private SingleFileArchive(Path file, String relativePath) {
        this.file = file;
        this.inputStream = null;
        this.tmpFileSupplier = null;
        this.relativePath = relativePath;
    }

    public void open(boolean strict) throws IOException {
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        if (!(entry instanceof SingleFileEntry)) {
            throw new IllegalArgumentException("Can only open input stream for SingleFileEntry, but given entry is " + entry.getClass());
        }
        return Files.newInputStream(this.getTmpFile(), new OpenOption[0]);
    }

    private Path getTmpFile() throws IOException {
        if (this.file != null) {
            return this.file;
        }
        if (this.tmpFile != null) {
            return this.tmpFile;
        }
        if (this.inputStream != null) {
            this.tmpFile = (Path)this.tmpFileSupplier.get();
            Files.copy(this.inputStream, this.tmpFile, StandardCopyOption.REPLACE_EXISTING);
            return this.tmpFile;
        }
        throw new IllegalArgumentException("Either file or inputStream must be non-null!");
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        if (!(entry instanceof SingleFileEntry)) {
            throw new IllegalArgumentException("Can only open input stream for SingleFileEntry, but given entry is " + entry.getClass());
        }
        return new FileInputSource(this.getTmpFile().toFile());
    }

    public Archive.Entry getJcrRoot() throws IOException {
        return null;
    }

    public Archive.Entry getRoot() throws IOException {
        return new SingleFileEntry(this);
    }

    public MetaInf getMetaInf() {
        return new DefaultMetaInf();
    }

    public Archive.Entry getEntry(String path) throws IOException {
        if (path.equals(this.relativePath)) {
            return new SingleFileEntry(this);
        }
        return null;
    }

    public Archive getSubArchive(String root, boolean asJcrRoot) throws IOException {
        return null;
    }

    public void close() {
        if (this.tmpFile != null) {
            try {
                Files.delete(this.tmpFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not delete temporary file");
            }
        }
    }

    public static class SingleFileEntry
    implements Archive.Entry {
        SingleFileArchive archive;

        SingleFileEntry(SingleFileArchive archive) {
            this.archive = archive;
        }

        public String getName() {
            return this.archive.relativePath;
        }

        public boolean isDirectory() {
            return false;
        }

        public Collection<? extends Archive.Entry> getChildren() {
            return Collections.emptyList();
        }

        public Archive.Entry getChild(String name) {
            return null;
        }
    }
}

